// Configuration de l'extension
// URL par défaut (utilisée en fallback si le serveur distant est injoignable)
const DEFAULT_SERVER_URL = 'https://marketplace-universe.fr';

// URL du endpoint qui renvoie la config à jour
// Hébergez ce JSON quelque part de stable (GitHub Pages, votre domaine, etc.)
// Le JSON attendu : { "serverUrl": "https://votre-domaine.com" }
const CONFIG_REMOTE_URL = '';

let SERVER_URL = DEFAULT_SERVER_URL;

async function loadRemoteConfig() {
  if (!CONFIG_REMOTE_URL) return;
  try {
    const res = await fetch(CONFIG_REMOTE_URL, { cache: 'no-cache' });
    if (res.ok) {
      const data = await res.json();
      if (data.serverUrl) {
        SERVER_URL = data.serverUrl.replace(/\/+$/, '');
      }
    }
  } catch {
    // Fallback silencieux sur DEFAULT_SERVER_URL
  }
}
